
#include "stdafx.h"
#include "CLS_NVDSDK_Interface.h"

extern CString g_strInstDir;

IMPLEMENT_FUNCTION(DEC_ClientStartup);
IMPLEMENT_FUNCTION(DEC_ClientCleanup);
IMPLEMENT_FUNCTION(DEC_ClientLogon);
IMPLEMENT_FUNCTION(DEC_ClientLogout);
IMPLEMENT_FUNCTION(DEC_ClientGetDecoderPara);
IMPLEMENT_FUNCTION(DEC_ClientSetIP);
IMPLEMENT_FUNCTION(DEC_ClientSetDDNS);
IMPLEMENT_FUNCTION(DEC_ClientSetCom);
IMPLEMENT_FUNCTION(DEC_ClientSetAlarmOut);
IMPLEMENT_FUNCTION(DEC_ClientSetTVInfo);
IMPLEMENT_FUNCTION(DEC_ClientSetChannelMode);
IMPLEMENT_FUNCTION(DEC_ClientSetLogo);
IMPLEMENT_FUNCTION(DEC_ClientGetLogo);
IMPLEMENT_FUNCTION(DEC_ClientGetLoopItemCount);
IMPLEMENT_FUNCTION(DEC_ClientGetLoopItem);
IMPLEMENT_FUNCTION(DEC_ClientSetLoopItem);
IMPLEMENT_FUNCTION(DEC_ClientDelLoopItem);
IMPLEMENT_FUNCTION(DEC_ClientStartLoop);
IMPLEMENT_FUNCTION(DEC_ClientStopLoop);
IMPLEMENT_FUNCTION(DEC_ClientGetLoopStatus);
IMPLEMENT_FUNCTION(DEC_ClientStartView);
IMPLEMENT_FUNCTION(DEC_ClientStopView);
IMPLEMENT_FUNCTION(DEC_ClientGetViewItem);
IMPLEMENT_FUNCTION(DEC_ClientSendKeyCode);
IMPLEMENT_FUNCTION(DEC_ClientPTZCtrl);
IMPLEMENT_FUNCTION(DEC_Client485Send);
IMPLEMENT_FUNCTION(DEC_ClientGetPTZprotocols);
IMPLEMENT_FUNCTION(DEC_ClientSoundCtrl);
IMPLEMENT_FUNCTION(DEC_ClientTalkServer);
IMPLEMENT_FUNCTION(DEC_ClientGetAudioStatus);
IMPLEMENT_FUNCTION(DEC_ClientGetTalkStatus);
IMPLEMENT_FUNCTION(DEC_ClientRebootDecoder);
IMPLEMENT_FUNCTION(DEC_ClientResetDefault);
IMPLEMENT_FUNCTION(DEC_ClientUpgrade);
IMPLEMENT_FUNCTION(DEC_ClientUpgradeLogo);
IMPLEMENT_FUNCTION(DEC_ClientUpgradeProtocol);
IMPLEMENT_FUNCTION(DEC_ClientDeleteProtocol);
IMPLEMENT_FUNCTION(DEC_ClientUpgradeWeb); 
IMPLEMENT_FUNCTION(DEC_ClientGetVersion);
IMPLEMENT_FUNCTION(DEC_ClientGetSDKVersion);
IMPLEMENT_FUNCTION(DEC_ClientGetCapability);   //add for guowei 2010-1-8
IMPLEMENT_FUNCTION(DEC_ClientSetComRecvNotify);
IMPLEMENT_FUNCTION(DEC_ClientStartPushStream);    //add for pushStream 2010.4.20
IMPLEMENT_FUNCTION(DEC_ClientStartPushStreamEx);    //add for pushStream 2013.3.4
IMPLEMENT_FUNCTION(DEC_ClientSendStream);
IMPLEMENT_FUNCTION(DEC_ClientStopPushStream);
IMPLEMENT_FUNCTION(DEC_ClientSetVGASize);
IMPLEMENT_FUNCTION(DEC_ClientUserChangePassword);
IMPLEMENT_FUNCTION(DEC_SetRegServer);
IMPLEMENT_FUNCTION(DEC_SetRegDevice);
IMPLEMENT_FUNCTION(DEC_SetRegChannel);
IMPLEMENT_FUNCTION(DEC_SetVolume);
IMPLEMENT_FUNCTION(DEC_SetSelectPicture);
IMPLEMENT_FUNCTION(DEC_SetDZInfo);
IMPLEMENT_FUNCTION(DEC_SetChannelSipConfig);
IMPLEMENT_FUNCTION(DEC_SetPlatformStart);
IMPLEMENT_FUNCTION(DEC_GetPlatformInfo);
IMPLEMENT_FUNCTION(DEC_GetRunningPlatformInfo);

IMPLEMENT_FUNCTION(DEC_ClientStartView_V1);
IMPLEMENT_FUNCTION(DEC_ClientStopView_V1);
IMPLEMENT_FUNCTION(DEC_ClientGetViewItemEx);
IMPLEMENT_FUNCTION(DEC_ClientGetViewItem_V1);
IMPLEMENT_FUNCTION(DEC_ClientSetLoopItemEx);
IMPLEMENT_FUNCTION(DEC_ClientSetLoopItem_V1);
IMPLEMENT_FUNCTION(DEC_ClientGetLoopItemEx);
IMPLEMENT_FUNCTION(DEC_ClientGetLoopItem_V1);
IMPLEMENT_FUNCTION(DEC_ClientSendRawFrame);	
IMPLEMENT_FUNCTION(DEC_ClientSetCommonEnable);
IMPLEMENT_FUNCTION(DEC_ClientGetCommonEnable);
IMPLEMENT_FUNCTION(DEC_ClientGetCommonEnableEx);
IMPLEMENT_FUNCTION(DEC_GetVolume);
IMPLEMENT_FUNCTION(DEC_ClientLogonEx);
IMPLEMENT_FUNCTION(DEC_ClientGetStreamBufferState);
IMPLEMENT_FUNCTION(DEC_ClientStreamControl);
IMPLEMENT_FUNCTION(DEC_ClientSendNonstandardRawFrame);
IMPLEMENT_FUNCTION(DEC_ClientStopPushStreamEx);
IMPLEMENT_FUNCTION(DEC_ClientStartPushStream_V1);
IMPLEMENT_FUNCTION(DEC_ClientConfigStreamInfo);
IMPLEMENT_FUNCTION(DEC_ClientGetDevConfig);
IMPLEMENT_FUNCTION(DEC_ClientSetDevConfig);
IMPLEMENT_FUNCTION(DEC_ClientGetClusterConfig);
IMPLEMENT_FUNCTION(DEC_ClientSetClusterConfig);
IMPLEMENT_FUNCTION(DEC_ClientNetLogQuery);
IMPLEMENT_FUNCTION(DEC_ClientNetLogGetLogfile);
IMPLEMENT_FUNCTION(DEC_ClientNetLogGetLogCount);
IMPLEMENT_FUNCTION(DEC_ClientSetNotify);
IMPLEMENT_FUNCTION(DEC_ClientSendCommand);
IMPLEMENT_FUNCTION(DEC_ClientRecvCommand);
IMPLEMENT_FUNCTION(DEC_ClientGetLogonState);
IMPLEMENT_FUNCTION(DEC_ClientSetSDKWorkMode);

HINSTANCE  CLS_NVDSDK_Interface::s_tLibrary = NULL;
CString   CLS_NVDSDK_Interface::m_szFilePath = _T("");
static  CLS_NVDSDK_Interface NVDSDK;

CLS_NVDSDK_Interface::CLS_NVDSDK_Interface()
{
    

}

CLS_NVDSDK_Interface::~CLS_NVDSDK_Interface()
{
    
}

bool CLS_NVDSDK_Interface::LoadDLL()
{
	if(m_szFilePath.Compare(_T("")) == 0)
	{
		m_szFilePath = g_strInstDir + _T("NVDSDK.dll");
		//OutputDebugString("------" + m_szFilePath + "------\n");
	}
	if (s_tLibrary)
		return true;

    s_tLibrary = ::LoadLibrary(m_szFilePath.Trim());
    if(!s_tLibrary) 
		return false;

    EXPORT_FUNCTION(s_tLibrary, DEC_ClientStartup);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientCleanup);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientLogon);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientLogout);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetDecoderPara);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientSetIP);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientSetDDNS);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientSetCom);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientSetAlarmOut);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientSetTVInfo);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientSetChannelMode);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientSetLogo);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetLogo);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetLoopItemCount);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetLoopItem);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientSetLoopItem);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientDelLoopItem);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientStartLoop);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientStopLoop);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetLoopStatus);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientStartView);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientStopView);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientStopView_V1)
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetViewItem);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientSendKeyCode);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientPTZCtrl);
    EXPORT_FUNCTION(s_tLibrary, DEC_Client485Send);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetPTZprotocols);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientSoundCtrl);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientTalkServer);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetAudioStatus);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetTalkStatus);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientRebootDecoder);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientResetDefault);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientUpgrade);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientUpgradeLogo);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientUpgradeProtocol);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientDeleteProtocol);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetVersion);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetSDKVersion);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientUpgradeWeb);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientSetComRecvNotify);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetCapability);       //add for guowei
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientStartPushStream);    //add for pushStream 2010.4.20
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientStartPushStreamEx);    //add 2013.3.4
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientSendStream);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientStopPushStream);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientSetVGASize);
    EXPORT_FUNCTION(s_tLibrary, DEC_ClientUserChangePassword);
    EXPORT_FUNCTION(s_tLibrary, DEC_SetRegServer);
    EXPORT_FUNCTION(s_tLibrary, DEC_SetRegDevice);
    EXPORT_FUNCTION(s_tLibrary, DEC_SetRegChannel);
    EXPORT_FUNCTION(s_tLibrary, DEC_SetVolume);
    EXPORT_FUNCTION(s_tLibrary, DEC_SetSelectPicture);
    EXPORT_FUNCTION(s_tLibrary, DEC_SetDZInfo);
    EXPORT_FUNCTION(s_tLibrary, DEC_SetChannelSipConfig);
    EXPORT_FUNCTION(s_tLibrary, DEC_SetPlatformStart);
    EXPORT_FUNCTION(s_tLibrary, DEC_GetPlatformInfo);
    EXPORT_FUNCTION(s_tLibrary, DEC_GetRunningPlatformInfo);

	EXPORT_FUNCTION(s_tLibrary, DEC_ClientStartView_V1);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetViewItemEx);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetViewItem_V1);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientSetLoopItemEx);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientSetLoopItem_V1);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetLoopItemEx);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetLoopItem_V1);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientSendRawFrame);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientSetCommonEnable);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetCommonEnable);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetCommonEnableEx);
	EXPORT_FUNCTION(s_tLibrary, DEC_GetVolume);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientLogonEx);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetStreamBufferState);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientStreamControl);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientSendNonstandardRawFrame);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientStopPushStreamEx);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientStartPushStream_V1);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientConfigStreamInfo);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetDevConfig);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientSetDevConfig);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetClusterConfig);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientSetClusterConfig);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientNetLogQuery);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientNetLogGetLogfile);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientNetLogGetLogCount);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientSetNotify);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientSendCommand);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientRecvCommand);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientGetLogonState);
	EXPORT_FUNCTION(s_tLibrary, DEC_ClientSetSDKWorkMode);

    return true;
}

void CLS_NVDSDK_Interface::FreeDLL()
{
    if(s_tLibrary)
    {
        ::FreeLibrary(s_tLibrary);
        s_tLibrary = NULL;
    }
}

